#include <vector>
#include <iostream>
#include <string>

struct polje {
	unsigned int x, y, tip;
};

unsigned int proveri_polje(std::vector<unsigned int>& farma, unsigned int x, unsigned int y, unsigned int d, unsigned int tip) {
	if(x >= 0 && x < d) {
		if(y >= 0 && y < d) {
			if(farma[y * d + x] == tip) {
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}else{
		return false;
	}
}

unsigned int proveri_tip(std::vector<unsigned int>& farma, std::vector<polje>& tmp, unsigned int x, unsigned int y, unsigned int d, unsigned int tip) {
	farma[y * d + x] = -1;
	tmp.push_back({x, y, tip});

	if(proveri_polje(farma, x+1, y, d, tip)) {proveri_tip(farma, tmp, x+1, y, d, tip);}
	if(proveri_polje(farma, x-1, y, d, tip)) {proveri_tip(farma, tmp, x-1, y, d, tip);}
	if(proveri_polje(farma, x, y+1, d, tip)) {proveri_tip(farma, tmp, x, y+1, d, tip);}
	if(proveri_polje(farma, x, y-1, d, tip)) {proveri_tip(farma, tmp, x, y-1, d, tip);}

	return 0;
}

unsigned int najv_x(std::vector<polje>& tmp) {
	unsigned int naj = 0;
	for(auto i : tmp) {
		if(i.x > naj) {naj = i.x;}
	}
	return naj;
}

unsigned int najv_y(std::vector<polje>& tmp) {
	unsigned int naj = 0;
	for(auto i : tmp) {
		if(i.y > naj) {naj = i.y;}
	}
	return naj;
}

unsigned int najm_x(std::vector<polje>& tmp) {
	unsigned int naj = 999999999;
	for(auto i : tmp) {
		if(i.x < naj) {naj = i.x;}
	}
	return naj;
}

unsigned int najm_y(std::vector<polje>& tmp) {
	unsigned int naj = 999999999;
	for(auto i : tmp) {
		if(i.y < naj) {naj = i.y;}
	}
	return naj;
}

bool proveri_kontinuitet(std::vector<polje>& tmp) {
	unsigned int w = najv_x(tmp);
	unsigned int h = najv_y(tmp);
	unsigned int sx = najm_x(tmp);
	unsigned int sy = najm_y(tmp);

	for(unsigned int y = sy; y <= h; y++) {
		for(unsigned int x = sx; x <= w; x++) {
			bool postoji = false;
			for(unsigned int i = 0; i < tmp.size(); i++) {
				if(tmp[i].x == x && tmp[i].y == y) {
					postoji = true;
				}
			}
			if(!postoji) {
				return false;
			}
		}
	}
	return true;
}

bool jedini_set(std::vector<unsigned int>& farma, unsigned int tip) {
	bool postoji = false;
	for(unsigned int i = 0; i < farma.size(); i++) {
		if(farma[i] == tip) {
			farma[i] = -1;
			postoji = true;
		}
	}
	return postoji;
}

int main() {
	std::vector<unsigned int> farma;
	std::string line;
	getline(std::cin, line);

	unsigned int d = std::stoi(line.substr(0, line.find(" ")));
	unsigned int k = std::stoi(line.substr(line.find(" ")+1));

	farma.resize(d*d);

	for(unsigned int y = 0; y < d; y++) {
		std::string red;
		getline(std::cin, red);

		for(unsigned int x = 0; x < d; x++) {
			farma[y * d + x] = std::stoi(red.substr(0, red.find(" ")));
			red = red.substr(red.find(" ")+1);
		}
	}

	unsigned int broj = 0;
	std::vector<polje> tmp;

	for(unsigned int y = 0; y < d; y++) {
		for(unsigned int x = 0; x < d; x++) {
			if(farma[y * d + x] != -1) {
				unsigned int tip = farma[y * d + x];
				proveri_tip(farma, tmp, x, y, d, tip);
				bool kon = proveri_kontinuitet(tmp);
				bool pos = !jedini_set(farma, tip);

				if(kon && pos) {
					broj++;
				}

				tmp.clear();
			}
		}
	}

	std::cout << broj  << '\n';

	return 0;
}